package ru.yandex.tours.avia

import ru.yandex.tours.avia.AviaClient.{Dictionaries, Response, RaspResponse, ResponseUpdated}
import ru.yandex.tours.model.search.FlightSearchRequest
import ru.yandex.tours.util.Monitorings
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.03.16
 */
class MonitoredAviaClient(client: AviaClient) extends AviaClient {

  private val errorRate = Monitorings("avia.client", devOnly = true).errorRate(
    "errors", warningRate = 0.1, maxRate = 0.4
  )

  override def getMinPriceFromRasp(request: FlightSearchRequest): Future[RaspResponse] = {
    client.getMinPriceFromRasp(request)
      .withErrorReservoir(errorRate)
  }

  override def getMinPrice(request: FlightSearchRequest, update: Boolean): Future[Response] = {
    client.getMinPrice(request, update)
      .withErrorReservoir(errorRate)
  }

  override def getMinPriceUpdated(searchId: String): Future[ResponseUpdated] = {
    client.getMinPriceUpdated(searchId)
      .withErrorReservoir(errorRate)
  }

  override def getDictionaries: Future[Dictionaries] = client.getDictionaries
}
