package ru.yandex.tours.backa

import scala.collection.mutable
import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.util.{IO, Logging}
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

class BackaPermalinks(data: Map[Int, String]) {
  val reversed: Map[String, Int] = Map() ++ (data map {case (k,v) => (v,k)})
  def getBackaPermalink(hotelId: Int): Option[String] = data.get(hotelId)
}

object BackaPermalinks extends DataDef[BackaPermalinks] with Logging {
  override def dataType: DataType = DataTypes.backaPermalinks

  override def parse(is: InputStream): BackaPermalinks = {
    var data = mutable.HashMap[Int, String]()
    for (Tabbed(IntValue(hotelId), permalink) <- IO.readLines(is)) {
      data += hotelId -> permalink
    }
    new BackaPermalinks(data.toMap)
  }
}