package ru.yandex.tours.balancer

import java.util.concurrent.ConcurrentHashMap
import scala.concurrent.duration.FiniteDuration

/**
  * Author: Krasheninnikov Alexander (alexcrush@yandex-team.ru)
  * Created: 2018.03.06
  */

class Balancer(allHosts: String, rootDC: String, deadTimeout: FiniteDuration)
{

  val hosts : Seq[String] = allHosts.split(",").map(_.trim).sortBy(!isInRootDC(_))

  private def isInRootDC(host: String) = {
    host.split("-").contains(rootDC)
  }

  private val deadHosts = new ConcurrentHashMap[String, Long]()

  private def isAlive(host: String) = {
    val t = Option(deadHosts.get(host))
    if (t.isDefined) {
      val now = System.currentTimeMillis()
      if (now - t.get > deadTimeout.toMillis) {
        deadHosts.remove(host)
        true
      } else {
        false
      }
    } else {
      true
    }
  }

  def aliveHosts() : Seq[String] = {
    val alive = hosts.filter(host => isAlive(host))
    if (alive.isEmpty) {
      // Nothing to try? Try all
      hosts
    } else {
      alive
    }
  }

  def markAsDead(host: String) : Unit = {
    deadHosts.put(host, System.currentTimeMillis())
  }
}
