package ru.yandex.tours.billing

import ru.yandex.tours.app.{AkkaSupport, Application}
import ru.yandex.vertis.billing.impl.HttpCampaignsClient
import ru.yandex.vertis.billing.util.http.HttpExecutorImpl

trait BillingComponents {
  def billingService: BillingService
}

trait DefaultBillingComponents extends BillingComponents { this: Application with AkkaSupport =>
  val campaignsClient = new HttpCampaignsClient(config.getString("billing.uri"), new HttpExecutorImpl())
  override val billingService = new HttpBillingService(campaignsClient)(akkaSystem, akkaSystem.dispatcher)
}
