package ru.yandex.tours.billing

import ru.yandex.tours.model.purchase.BillingObject
import ru.yandex.tours.util.Logging
import ru.yandex.vertis.billing.Model.CampaignHeader

trait BillingService extends BillingServiceCommon {
  def getBillingInfo(partnerCode: String, offerId: String): Option[BillingObject]

  def isActive(partnerCode: String): Boolean
}

trait BillingServiceCommon extends Logging {
  def isEnabled(header: CampaignHeader): Boolean = {
    val product = header.getProduct
    if (product.getGoodsCount != 1) {
      log.warn(s"Strange good count on billing. Header id is ${header.getId}")
      false
    } else {
      val goods = header.getProduct.getGoods(0)
      val cost = goods.getPlacement.getCost
      if (cost.hasPerClick) {
        // This is per click campaign
        val order = header.getOrder
        header.getSettings.getIsEnabled && (order.getTotalIncome > order.getTotalSpent)
      } else {
        // This is per action campaign
        header.getSettings.getIsEnabled
      }
    }
  }
}

object BillingServiceCommon extends BillingServiceCommon