package ru.yandex.tours.calendar

import org.joda.time.LocalDate
import ru.yandex.tours.model.Calendar.{Document, FlightDay, FlightMatrix}
import ru.yandex.tours.model.util.DateInterval
import ru.yandex.tours.services.CalendarService
import spray.caching.LruCache

import scala.concurrent.duration._
import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 25.04.16
 */
class CachingCalendarService(calendarService: CalendarService)
                            (implicit ec: ExecutionContext) extends CalendarService {

  private case class NearestRequest(from: Int, to: Int, when: LocalDate, interval: DateInterval)

  private val nearestCache = LruCache[Option[FlightDay]](maxCapacity = 5000, timeToLive = 10.minutes)

  override def getFlightMatrix: Future[FlightMatrix] = calendarService.getFlightMatrix

  override def getNearestFlightDay(from: Int, to: Int,
                                   when: LocalDate, interval: DateInterval): Future[Option[FlightDay]] = {
    nearestCache(NearestRequest(from, to, when, interval)) {
      calendarService.getNearestFlightDay(from, to, when, interval)
    }
  }

  override def getHasFlights(from: Int, to: Int, nights: Option[Int]): Future[Seq[Document]] =
    calendarService.getHasFlights(from, to, nights)

  override def getNoFlights(from: Int, to: Int, nights: Option[Int]): Future[Seq[Document]] =
    calendarService.getNoFlights(from, to, nights)
}
