package ru.yandex.tours.clickhouse

import ru.yandex.tours.app.{AkkaSupport, Application, HttpSupport}
import ru.yandex.tours.util.lang.RichConfig

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.03.16
 */
trait ClickHouseSupport {
  app: Application =>

  def clickHouseClient: ClickHouseClient
}

trait DefaultClickHouseSupport extends ClickHouseSupport {
  app: Application with HttpSupport with AkkaSupport =>

  lazy val clickHouseClient = {
    val conf = config.getConfig("tours.clickhouse")
    val client = new DefaultClickHouseClient(httpClient, conf, app.dataCenter)(akkaSystem.dispatcher)
    val instrumented = new InstrumentedClickHouseClient(client)
    val queued = if (conf.hasPath("max-parallelism")) {
      new QueuedClickHouseClient(instrumented,
        conf.getInt("max-parallelism"),
        conf.getScalaDuration("deadline")
      )(akkaSystem, akkaSystem.dispatcher)
    } else instrumented

    if (conf.hasPath("batching")) {
      val batchInterval = conf.getFiniteDuration("batching.interval")
      val retryInterval = conf.getFiniteDuration("batching.retry-interval")
      val retryAttempts = conf.getInt("batching.retry-attempts")
      new BatchingClickHouseClient(queued, akkaSystem.scheduler,
        batchInterval, retryInterval, retryAttempts)(akkaSystem.dispatcher)
    } else queued
  }

}