package ru.yandex.tours.clickhouse

import ru.yandex.tours.util.Metrics
import ru.yandex.tours.util.lang.Futures._

import scala.concurrent.Future
import scala.util.Failure

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.03.16
 */
class InstrumentedClickHouseClient(clickHouseClient: ClickHouseClient,
                                   name: String = "default") extends ClickHouseClient {

  override def database: String = clickHouseClient.database

  private val metrics = Metrics(s"clickhouse.$name")
  private val queryTimer = metrics.getTimer("query")
  private val updateTimer = metrics.getTimer("update")
  private val errorMeter = metrics.getMeter("error")
  private val updateErrorMeter = metrics.getMeter("update_error")

  override def query(query: String): Future[Iterator[Seq[String]]] = {
    val ctx = queryTimer.time()
    clickHouseClient.query(query)
      .withTimerContext(ctx)
      .withErrorRateMeter(errorMeter)
  }

  override def update(query: String, data: Seq[String]): Future[Unit] = {
    val ctx = updateTimer.time()
    clickHouseClient.update(query, data)
      .withTimerContext(ctx)
      .withErrorRateMeter(updateErrorMeter)
  }
}
