package ru.yandex.tours.clickhouse

import akka.actor.ActorSystem
import ru.yandex.tours.util.concurrent.AsyncWorkQueue

import scala.concurrent.duration.Duration
import scala.concurrent.{ExecutionContext, Future}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 16.03.16
 */
class QueuedClickHouseClient(clickHouseClient: ClickHouseClient, maxParallelism: Int, deadline: Duration)
                            (implicit akkaSystem: ActorSystem, ec: ExecutionContext) extends ClickHouseClient {

  override def database: String = clickHouseClient.database

  private val queue = new AsyncWorkQueue(maxParallelism)

  override def query(query: String): Future[Iterator[Seq[String]]] =
    queue.submit(clickHouseClient.query(query), deadline)

  override def update(query: String, data: Seq[String]): Future[Unit] =
    clickHouseClient.update(query, data)
}
