package ru.yandex.tours.clustering

object Clustering {
  trait LinkTrait {
    def parent: Int
    def child: Int

//    assume(child < parent, "Child should be less than parent")
  }

  trait LinkWithConfidenceTrait extends LinkTrait {
    def confidence: Double
  }

  case class LinkWithConfidence(parent: Int, child: Int, confidence: Double) extends LinkWithConfidenceTrait

  case class Link(parent: Int, child: Int) extends LinkTrait
}
