package ru.yandex.tours.clustering

import ru.yandex.tours.clustering.Clustering.LinkTrait
import ru.yandex.tours.util.collections.DisjointSet

class ExcessLinkClassifier[T <: LinkTrait, U <: LinkTrait](mandatoryLinks: Iterable[T]) {
  val disjointSet = new DisjointSet()
  mandatoryLinks.foreach { link =>
    disjointSet.join(link.child, link.parent)
  }

  /**
   * First element is links, which we should add to graph
   * Second element is excessive links
   */
  def classify(links: Seq[U]): (Seq[U], Seq[U]) = {
    links.partition { link =>
      val shouldAdd = disjointSet.isSame(link.child, link.parent)
      disjointSet.join(link.child, link.parent)
      shouldAdd
    }
  }
}
