package ru.yandex.tours.currency

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.BaseModel.Currency
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed

import scala.collection.mutable

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.04.16
 */
class CurrencyRates(rates: Map[(Currency, Currency), BigDecimal]) {

  def getRate(fromCurrency: Currency, toCurrency: Currency): BigDecimal = {
    rates.get(fromCurrency -> toCurrency)
      .orElse(rates.get(toCurrency -> fromCurrency).map(1 / _))
      .getOrElse(sys.error(s"Cannot convert from $fromCurrency to $toCurrency"))
  }


}

object CurrencyRates extends DataDef[CurrencyRates] {

  override def dataType: DataType = DataTypes.currencyRates

  override def parse(is: InputStream): CurrencyRates = {
    val map = IO.readLines(is).collect {
      case Tabbed(from, to, rate) =>
        (Currency.valueOf(from), Currency.valueOf(to)) -> BigDecimal(rate)
    }.toMap
    new CurrencyRates(map)
  }

  def empty: CurrencyRates = new CurrencyRates(Map.empty)
}
