package ru.yandex.tours.direction

import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.hotels.HotelsIndex

case class RegionWithHotelCount(region: Region, hotelCount: Int)

case class DirectionWithHotelCount(direction: Direction, hotelCount: Int)

class CountryResortsService(directions: Directions,
                            hotelsIndex: HotelsIndex,
                            tree: Tree,
                            geoMapping: GeoMappingHolder) {

  def getTopResorts(geoId: Int, size: Int): Seq[DirectionWithHotelCount] = {
    val all = for {
      child <- getAllSubRegions(geoId)
      direction <- directions.get(child.id)
      hotelCount = hotelsIndex.hotelsCountInRegion(child.id)
      if hotelCount > 0
    } yield DirectionWithHotelCount(direction, hotelCount)
    all.toSeq.sortBy(-_.direction.maxRelevance).take(size)
  }

  def getResorts(geoId: Int): Iterable[RegionWithHotelCount] = {
    for {
      region <- getAllSubRegions(geoId)
      count = hotelsIndex.hotelsCountInRegion(region.id)
      if count > 0
    } yield RegionWithHotelCount(region, count)
  }

  private def getAllSubRegions(geoId: Int): Iterable[Region] = {
    for {
      region <- tree.region(geoId).toIterable
      child <- tree.allChildren(region)
      if geoMapping.isKnownDestCity(child.id)
    } yield child
  }

}
