package ru.yandex.tours.direction

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.util.parsing.{IntValue, DoubleValue, Tabbed}

import scala.collection.mutable
import scala.collection.mutable.ListBuffer
import scala.io.Source

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 22.06.15
 */
class DirectionsSimilarity(map: Map[Int, Map[Int, Double]]) {
  def getSimilar(geoId: Int): List[Int] = {
    map.getOrElse(geoId, Map.empty).toList.sortBy(-_._2).map(_._1)
  }

  def getSimilarity(geoId1: Int, geoId2: Int) = {
    map.getOrElse(geoId1, Map.empty).getOrElse(geoId2, 0d)
  }
}

object DirectionsSimilarity extends DataDef[DirectionsSimilarity] {
  override def dataType: DataType = DataTypes.geoSimilarity

  override def parse(is: InputStream): DirectionsSimilarity = {
    val map = new mutable.HashMap[Int, ListBuffer[(Int, Double)]]
    Source.fromInputStream(is).getLines().foreach {
      case Tabbed(IntValue(geo1), IntValue(geo2), DoubleValue(similarity)) =>
        map.getOrElseUpdate(geo1, ListBuffer.empty) += (geo2 -> similarity)
        map.getOrElseUpdate(geo2, ListBuffer.empty) += (geo1 -> similarity)
    }

    new DirectionsSimilarity(map.mapValues(_.toMap).toMap)
  }

  def empty = new DirectionsSimilarity(Map.empty)
}
