package ru.yandex.tours.direction

import ru.yandex.tours.geo.base.region
import ru.yandex.tours.util.Collections._

import scala.collection.mutable

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 06.05.15
 */
object DirectionsUtils {
  def collectDirections(directions: Seq[Direction], withPrice: Set[Int], tree: region.Tree, count: Int): Vector[Direction] = {
    val map = directions.map(d => d.region.id -> d).toMap
    val roots = new mutable.HashSet[Direction]
    val parents = new mutable.HashMap[Direction, Direction]

    for (direction <- directions) {
      roots += direction
      for {
        parent <- tree.pathToRoot(direction.region).filter(_ != direction.region).find(r => map.contains(r.id))
        parentDirection <- map.get(parent.id)
      } {
        parents(direction) = parentDirection
        roots -= direction
      }
    }

    val children = parents.toMap.inverse
    val withPrice2 = withPrice.flatMap(map.get)

    collectDirections(roots.toSeq, children, withPrice2, count)
  }

  def collectDirections(roots: Seq[Direction],
                        children: Map[Direction, Seq[Direction]],
                        withPrice: Set[Direction],
                        count: Int): Vector[Direction] = {
    var result = (Vector.empty ++ roots).filter(withPrice)
    while (result.size < count) {
      var replaced = false
      for (toReplace <- result.filter(children.contains).find(d => children(d).count(withPrice) >= 2)) {
        replaced = true
        result = result.filter(_ != toReplace) ++ children(toReplace).filter(withPrice).take(2)
      }
      if (!replaced) return result
    }
    result
  }
}
