package ru.yandex.tours.direction

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.model.direction.HotDirection
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

import scala.io.Source

/**
  * Created by asoboll on 19.07.17.
  */
class HotDirections(val map: Map[Int, HotDirection]) {
  def isHot(geoId: Int, price: Int): Boolean = map.get(geoId).exists(_.maxPrice >= price)
}

object HotDirections extends DataDef[HotDirections] {
  override def dataType: DataType = DataTypes.hotDirections

  override def parse(is: InputStream): HotDirections = {
    val directions = Source.fromInputStream(is).getLines().map {
      case Tabbed(countryName, IntValue(geoId), IntValue(maxPrice), regionName) =>
        HotDirection(geoId, maxPrice, Some(regionName).filter(_.nonEmpty), Some(countryName).filter(_.nonEmpty))
    }
    new HotDirections(directions.map(d => d.geoId -> d).toMap)
  }
}
