package ru.yandex.tours.direction.layout

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 08.07.15
 */
case class Layout(rows: Seq[Layout.Row]) {

  val size: Int = rows.flatMap(_.items).size

  def +(row: Layout.Row): Layout = copy(rows :+ row)
}

object Layout {

  case class Item(position: Int, size: Int)

  case class Row(items: Item*) {
    def size: Int = items.size
  }

  private val row1 = Row(Item(1, 8))
  private val row2 = Row(Item(1, 4), Item(3, 4))
  private val row3_1 = Row(Item(1, 2), Item(3, 4), Item(5, 2))
  private val row3_2 = Row(Item(1, 4), Item(3, 2), Item(7, 2))
  private val row4_1 = Row(Item(1, 1), Item(2, 1), Item(3, 4), Item(5, 2))
  private val row4_2 = Row(Item(1, 4), Item(3, 2), Item(7, 1), Item(8, 1))
  private val row4_static = Row(Item(1, 2), Item(3, 2), Item(5, 2), Item(7, 2))
  private val row5 = Row(Item(1, 1), Item(2, 4), Item(4, 1), Item(5, 1), Item(8, 1))
  private val row6 = Row(Item(1, 2), Item(3, 1), Item(4, 1), Item(5, 1), Item(6, 1), Item(7, 2))

  private val rows = Seq(row1, row2, row3_1, row3_2, row4_1, row4_2, row5, row6)

  val empty = new Layout(Seq.empty)

  val full = new Layout(
    Seq(
      row6,
      row4_1,
      row5,
      row4_2,
      row1
    )
  )

  def staticBySize(size: Int): Layout = {
    val fullCount = size / 4
    val restCount = size % 4

    val fullRows = Vector.fill(fullCount)(row4_static)
    val lastRow = if (restCount > 0) Vector(Row(row4_static.items.take(restCount): _*)) else Vector.empty

    new Layout(fullRows ++ lastRow)
  }

  def bySize(size: Int): Layout = {
    if (size == 20) full
    else rows.reverse.foldLeft((Layout.empty, size)) {
      case ((layout, remaining), row) =>
        if (row.size > remaining) (layout, remaining)
        else (layout + row) -> (remaining - row.size)
    }._1
  }
}


