package ru.yandex.tours.extdata

import java.util

import ru.yandex.extdata.common.meta.{DataType, DataTypeRegistry}
import ru.yandex.tours.hotels.ShardedYoctoHotelsIndex
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.model.hotels.Partners.Partner

import scala.collection.JavaConverters._
import scala.collection.immutable.IndexedSeq

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.02.15
 */
object DataTypes {

  private val list = new util.ArrayList[DataType]()

  private def dataType(name: String, currentFormatVersion: Int = DataType.DEFAULT_FORMAT_VERSION): DataType = {
    require(list.asScala.forall(_.getName != name), s"DataType [$name] already defined")
    val dt = new DataType(name, currentFormatVersion)
    list add dt
    dt
  }

  val jordan = dataType("jordan.json", 1)

  val geobase = dataType("geobase.xml", 2)
  val regions = dataType("regions.xml", 2)
  val regionBoundaries = dataType("region_boundaries.tsv", 1)

  val searchSettings = dataType("search_settings.json", 1)

  val brandings = dataType("brandings.tsv")

  val hotelsVideo = dataType("hotels_video", 1)
  val hotelsRatings = dataType("hotels_ratings", 2)
  val hotelsPanoramas = dataType("hotels_panoramas.tsv", 1)

  val agenciesProto = dataType("agencies.proto", 2)
  val metro = dataType("metro", 2)

  val operators = dataType("operators", 2)
  val hotel_providers = dataType("hotel_providers", 2)

  val verba = dataType("verba.xml", 1)

  val hotelPriorities = dataType("hotel_priorities_for_suggest.tsv", 2)
  val resortPriorities = dataType("resorts_priorities_for_suggest.tsv", 2)
  val countryPriorities = dataType("countries_priorities_for_suggest.tsv", 2)

  val departureStats = dataType("departure_stats.tsv", 1)

  val geoSimilarity = dataType("geo_similarity.tsv", 1)
  val hotelsSimilarity = dataType("hotels_similarity.tsv", 1)

  val cities = dataType("cities.tsv", 2)
  val countries = dataType("countries.tsv", 2)
  val departures = dataType("departures.tsv", 2)
  val airports = dataType("airports.tsv", 1)

  val ltActiveCountries = dataType("lt_active_countries", 1)
  val oldLtCities = dataType("old_lt_cities.tsv")
  val oldLtCountries = dataType("old_lt_countries.tsv")
  val oldLtDepartures = dataType("old_lt_departures.tsv")

  val partnerRegions = dataType("partner_regions.tsv", 2)
  val partnerRegionHotelCounts = dataType("partner_region_hotel_counts.tsv", 1)
  val geoMatchingHypotheses = dataType("geo_matching_hypotheses.tsv", 1)

  val iso2country = dataType("iso2country.tsv", 1)
  val aviaAirports = dataType("avia_airports.tsv", 3)
  val aviaCities = dataType("avia_cities.tsv", 2)
  val airportRecommendations = dataType("airport_recommendations.tsv", 2)

  val directions = dataType("directions", 4)

  val pansions = dataType("pansions", 1)

  val currencyRates = dataType("currency_rates.tsv", 1)

  val otaHotelMappings = dataType("ota_hotel_mappings.tsv", 1)
  val otaOperatorMappings = dataType("ota_operator_mappings.tsv", 1)
  val otaCitiesMappings = dataType("ota_cities_mappings.tsv", 1)
  val substitutePhones = dataType("substitute_phones.tsv")
  val customerToOperator = dataType("customer_to_tour_operator")
  val agenciesShows = dataType("agencies_shows.tsv")
  val partnerConversion = dataType("partner_conversion.tsv")
  val offlineAgencyBilling = dataType("offline_agency_billing")
  val hotelBilling = dataType("hotel_billing")
  val cmHotelBilling = dataType("cm_hotel_billing")
  val offlineAgencyPartnering = dataType("offline_agency_partnering")
  val onlineAgencies = dataType("online_agencies", 2)
  val geoSynonyms = dataType("geo.synonyms.tsv")
  val hiddenFilters = dataType("hidden_filters.tsv")
  val hotelsExport = dataType("hotels_export.tsv.gz", 2)

  val hotelPartnerRatings = dataType("hotel_partner_ratings")
  val hotelUGCRatings = dataType("hotel_ugc_ratings.tsv")
  val backaPermalinks = dataType("backa_permalinks.tsv")

  val hotelsVisits = dataType("hotels_visits.tsv", 1)

  val tanker = dataType("tanker.json", 1)

  val geoSuggest = dataType("geo.suggest", 1)

  val hotelsTfIdfModel = dataType("hotels_tf_idf", 1)

  val clusteringMatrixnetModel = dataType("clustering.mx.info", 2)

  //wizard stuff
  val stopWordsTrie = dataType("stop_words.trie", 3)
  val wizardTrie = dataType("wizard.trie", 3)
  val wizardReqAnsTrie = dataType("wizard.reqans.trie", 3)

  val wizardReqAns = dataType("wizard.reqans.tsv", 1)
  val dates = dataType("dates.tsv", 1)
  val wizardGeo = dataType("geo.tsv", 2)
  val hotelNameParts = dataType("hotel_name_parts.tsv", 3)
  val ignoreWords = dataType("ignore_words.tsv", 1)
  val operatorAliases = dataType("operators.tsv", 1)
  val stopWords = dataType("stop_words.txt", 1)
  val wizardMarkers = dataType("wizard.markers", 1)

  val skiResorts = dataType("ski_resorts.json", 4)
  val slopes = dataType("slopes.tsv", 1)

  val hcId2Key = dataType("hc_id2key", 1)

  val hotDirections = dataType("hot_directions.tsv", 1)

  case class WI(formatVersion: Int, count: Int) extends ShardedIndex(formatVersion, count, "wizard")

  val wizardIndex = WI(formatVersion = 1, count = 32)

  case class ShardedHotelsIndex(formatVersion: Int, count: Int)
    extends ShardedIndex(formatVersion, count, "sharded_hotels")

  val shardedHotels = ShardedHotelsIndex(formatVersion = 4, count = ShardedYoctoHotelsIndex.SHARDS_COUNT)

  case class ShardedMicroOffers(formatVersion: Int, count: Int)
    extends ShardedIndex(formatVersion, count, "micro_offers")

  val shardedMicroOffers = ShardedMicroOffers(formatVersion = 1, count = 16)

  abstract class ShardedIndex(formatVersion: Int, count: Int, name: String) {
    val dataTypes: IndexedSeq[DataType] = (0 until count).map(i => dataType(s"$name.$i.index", formatVersion))
    def apply(i: Int): DataType = dataTypes.apply(i)
  }

  val partnerTrees: Map[Partner, DataType] = Partners.values.iterator.map { partner =>
    partner -> dataType(s"${partner}_regions", 1)
  }.toMap

  val registry = new DataTypeRegistry(list)
}
