package ru.yandex.tours.extdata

import java.io.{FileInputStream, File, OutputStream, InputStream}

import org.apache.commons.io.IOUtils
import ru.yandex.tours.util.file._
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService

/**
 * ExtDataService for local directory with files.
 *
 * Ignores data versions
 */
class LocalExtDataService(dataFolder: File) extends ExtDataService {

  private def fileFor(dataType: DataType) = dataFolder / dataType.getName

  override def writeDataTo(`type`: DataType, version: Int, stream: OutputStream): Unit = {
    writeDataTo(`type`, stream)
  }

  override def dataAlreadyLoaded(`type`: DataType): Boolean = {
    fileFor(`type`).exists()
  }

  override def writeDataTo(`type`: DataType, stream: OutputStream): Unit = {
    val is = readData(`type`)
    try {
      IOUtils.copy(is, stream)
    } finally {
      IOUtils.closeQuietly(is)
    }
  }

  override def readData(`type`: DataType): InputStream = {
    new FileInputStream(fileFor(`type`))
  }

  override def readData(`type`: DataType, version: Int): InputStream = {
    readData(`type`)
  }
}
