package ru.yandex.tours.filter

import ru.yandex.tours.filter.holder.hotel._
import ru.yandex.tours.filter.holder.snippet._
import ru.yandex.tours.model.filter.{SnippetFilter, HotelFilter, Filter}
import ru.yandex.tours.model.hotels.Features
import ru.yandex.tours.model.hotels.Features.{BooleanFeature, EnumFeature}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}
import spray.routing.Directive1
import spray.routing.Directives._

object Filters extends CommonDirectives {
  val hotelHolders: Seq[HotelFilterHolder] = Seq(
    new BooleanFeatureFilterHolder(Features.feature[BooleanFeature]("private_beach")),
    new EnumFeatureFilterHolder(Features.feature[EnumFeature]("hotel_line")),
    new EnumFeatureFilterHolder(Features.feature[EnumFeature]("beach")),
    StarFilterHolder,
    WifiFilterHolder,
    HotelTypeFilterHolder,
    new EnumFeatureFilterHolder(Features.feature[EnumFeature]("slope_distance_enum"))
  )

  val internalHotelHolders: Seq[HotelFilterHolder] = Seq(
    GeoIdFilterHolder,
    PartnerIdFilterHolder,
    SearchTypeFilterHolder
  )

  val snippetHolders: Seq[SnippetFilterHolder] = Seq(
    ExcludeTourByIdFilterHolder,
    HotelIdFilterHolder,
    PansionFilterHolder,
    PriceFilterHolder,
    TourOperatorFilterHolder,
    HotelProviderFilterHolder
  )

  val filterHolders: Seq[FilterHolder[Filter]] = hotelHolders ++ snippetHolders

  private def combineDirectives[T](directives: Iterable[Directive1[_ <: T]]) = {
    directives.foldLeft(provide(List.empty[T])) {
      case (seqDirective, filterDirective) => seqDirective & filterDirective hmap {
        case collected :: filter :: HNil => filter :: collected
      }
    }
  }

  val hotelFilters = combineDirectives[HotelFilter](hotelHolders.map(_.directive))

  val snippetFilters = combineDirectives[SnippetFilter](snippetHolders.map(_.directive))

  val internalHotelFilters = combineDirectives[HotelFilter]((hotelHolders ++ internalHotelHolders).map(_.directive))

  val filters = (hotelFilters & snippetFilters) hmap {
    case hotelFilter :: snippetFilter :: HNil => hotelFilter ++ snippetFilter
  }
}
