package ru.yandex.tours.filter

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.filter.HiddenFilters.EnabledAndHidden
import ru.yandex.tours.filter.holder.snippet.PansionFilterHolder
import ru.yandex.tours.model.filter.Filter
import ru.yandex.tours.model.filter.snippet.{HotelProviderFilter, TourOperatorFilter}
import ru.yandex.tours.model.search.SearchType.SearchType
import ru.yandex.tours.model.search.{HotelSearchRequest, SearchType}
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

class HiddenFilters(geoId2hidden: Map[Int, Set[String]]) {

  def classify(request: HotelSearchRequest,
               filters: Iterable[Filter],
               searchType: SearchType): EnabledAndHidden = {
    var toHide = geoId2hidden.getOrElse(request.to, Set.empty[String])
    if (searchType == SearchType.ROOMS) toHide ++= Set(PansionFilterHolder.name, TourOperatorFilter.name)
    if (searchType == SearchType.TOURS) toHide += HotelProviderFilter.name
    val (hidden, enabled) = filters.partition(f => toHide.contains(f.name))
    EnabledAndHidden(enabled, hidden.map(_.name))
  }
}

object HiddenFilters extends DataDef[HiddenFilters] {
  case class EnabledAndHidden(enabled: Iterable[Filter], hidden: Iterable[String])

  override def dataType: DataType = DataTypes.hiddenFilters

  override def parse(is: InputStream): HiddenFilters = {
    try {
      val map = scala.io.Source.fromInputStream(is).getLines().map {
        case Tabbed(IntValue(geoId), name) => geoId -> name
      }.toSeq.groupBy(_._1).map {
        case (geoId, values) => geoId -> values.map(_._2).toSet
      }
      new HiddenFilters(map)
    } finally {
      is.close()
    }
  }
}