package ru.yandex.tours.filter

import org.json.{JSONArray, JSONObject}

object State {
  sealed trait AllowedState {
    def name: String

    def putToJson(x: JSONObject)
  }

  case class Hidden(name: String) extends AllowedState {
    override def putToJson(x: JSONObject): Unit = x.put(name, "hidden")
  }

  case class StringValues(name: String, values: Iterable[String]) extends AllowedState {
    override def putToJson(x: JSONObject): Unit = {
      val ar = new JSONArray()
      values.foreach(ar.put)
      x.put(name, ar)
    }
  }

  case class IntValues(name: String, values: Iterable[Int]) extends AllowedState {
    override def putToJson(x: JSONObject): Unit = {
      val ar = new JSONArray()
      values.foreach(ar.put)
      x.put(name, ar)
    }
  }

  case class BooleanValue(name: String, value: Boolean) extends AllowedState {
    override def putToJson(x: JSONObject): Unit = x.put(name, value)
  }
}
