package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.State.AllowedState
import ru.yandex.tours.filter.{HotelFilterHolder, State}
import ru.yandex.tours.model.filter.hotel.BooleanFeatureFilter
import ru.yandex.tours.model.filter.{HotelFilter, BooleanValue, FilterableValue}
import ru.yandex.tours.model.hotels.Features.{BooleanFeature, BooleanFeatureValue}
import ru.yandex.tours.model.hotels.Hotel
import shapeless.{::, HNil}
import spray.routing.Directives._

case class BooleanFeatureFilterHolder(feature: BooleanFeature) extends HotelFilterHolder {
  override def getValues(hotel: Hotel): Seq[FilterableValue] = hotel.features.find(_.feature == feature) match {
    case Some(BooleanFeatureValue(_, v)) => v.map(BooleanValue.apply).toSeq
    case _ => Seq.empty
  }

  override def directive = parameter(name.as[Boolean].?) hmap {
    case value :: HNil => BooleanFeatureFilter(feature, value.map(BooleanValue))
  }

  override val name: String = feature.name

  override def toState(values: Set[FilterableValue]): AllowedState = State.BooleanValue(name, values.contains(BooleanValue(x = true)))

  override def getValues: Seq[FilterableValue] = Seq(BooleanValue(true))

  override def construct(values: Seq[FilterableValue]): HotelFilter = BooleanFeatureFilter(feature, values.collect { case x: BooleanValue => x }.headOption)
}
