package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.hotel.EnumFeatureFilter
import ru.yandex.tours.model.filter.{HotelFilter, FilterableValue, StringValue}
import ru.yandex.tours.model.hotels.Features.{EnumFeature, EnumFeatureValue}
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}
import spray.routing.Directives._
import spray.routing.{Directive1, MalformedQueryParamRejection}

case class EnumFeatureFilterHolder(feature: EnumFeature) extends HotelFilterHolder with CommonDirectives {
  override def getValues(hotel: Hotel): Seq[FilterableValue] = hotel.features.find(_.feature == feature) match {
    case Some(EnumFeatureValue(_, v)) => v.map(StringValue.apply).toSeq
    case _ => Seq.empty
  }

  override def directive: Directive1[EnumFeatureFilter] = array(name, isEmptyOk = true) hflatMap {
    case values :: HNil =>
      val filteredValues = values.filter(_.nonEmpty)
      filteredValues.find(t => !feature.values.contains(t)) match {
        case None => provide(EnumFeatureFilter(feature, filteredValues.map(StringValue)))
        case Some(unknownValue) => reject(MalformedQueryParamRejection(name, s"'$unknownValue' is unknown value. Valid value are ${feature.values.mkString(", ")}"))
      }
  }

  override val name: String = feature.name

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })

  override def getValues: Seq[FilterableValue] = feature.values.map(StringValue).toSeq

  override def construct(values: Seq[FilterableValue]): HotelFilter = EnumFeatureFilter(feature, values.collect { case x: StringValue => x})
}
