package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, IntValues}
import ru.yandex.tours.model.filter.hotel.GeoIdFilter
import ru.yandex.tours.model.filter.{FilterableValue, HotelFilter, IntValue}
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.11.15
 */
object GeoIdFilterHolder extends HotelFilterHolder with CommonDirectives {
  override def getValues(hotel: Hotel): Seq[FilterableValue] = Seq.empty

  override def directive = intArray(name, isEmptyOk = true) hmap {
    case geoIds :: HNil => new GeoIdFilter(geoIds)
  }

  override def name: String = GeoIdFilter.name

  override def toState(values: Set[FilterableValue]): AllowedState = IntValues(name, Seq.empty)

  override def getValues: Seq[FilterableValue] = Seq.empty

  override def construct(values: Seq[FilterableValue]): HotelFilter = new GeoIdFilter(values.collect { case x: IntValue => x.x })
}