package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{StringValues, AllowedState}
import ru.yandex.tours.model.filter.hotel.HotelTypeFilter
import ru.yandex.tours.model.filter.{FilterableValue, HotelFilter, StringValue}
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.hotels.HotelsHolder.HotelType
import ru.yandex.tours.util.spray.CommonDirectives
import spray.routing.Directive1

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 27.10.15
 */
object HotelTypeFilterHolder extends HotelFilterHolder with CommonDirectives {
  private def enumValues = HotelType.values().filter(_ != HotelType.UNKNOWN)

  override def getValues: Seq[FilterableValue] = enumValues.map(HotelTypeFilter.toFilterableValue)

  override def getValues(hotel: Hotel): Seq[FilterableValue] = Seq(HotelTypeFilter.toFilterableValue(hotel.`type`))

  override def construct(values: Seq[FilterableValue]): HotelFilter = new HotelTypeFilter(values)

  override def name: String = HotelTypeFilter.name

  override def directive: Directive1[_ <: HotelFilter] = enumArray(name, enumValues, isEmptyOk = true) map {
    hotelTypes => HotelTypeFilter.construct(hotelTypes)
  }

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })
}
