package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.hotel.PartnerIdFilter
import ru.yandex.tours.model.filter.{FilterableValue, HotelFilter, IntValue, StringValue}
import ru.yandex.tours.model.hotels.{Hotel, Partners}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}
import spray.routing.Directive

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 02.02.16
 */
object PartnerIdFilterHolder extends HotelFilterHolder with CommonDirectives {
  override def getValues(hotel: Hotel): Seq[FilterableValue] =
    hotel.partnerIds.map(_.partner.toString).toSeq.distinct.map(StringValue)

  override def directive: Directive[::[PartnerIdFilter, HNil]] =
    enumArray(name, Partners.values.toArray, isEmptyOk = true) map { partners =>
      new PartnerIdFilter(partners.map(_.id))
    }

  override def name: String = PartnerIdFilter.name

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, Seq.empty)

  override def getValues: Seq[FilterableValue] = Partners.values.map(x => StringValue(x.toString)).toSeq

  override def construct(values: Seq[FilterableValue]): HotelFilter =
    new PartnerIdFilter(values.collect {
      case StringValue(x) => Partners.withName(x).id
      case IntValue(id) => id
    })
}