package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter._
import ru.yandex.tours.model.filter.hotel.SearchTypeFilter
import ru.yandex.tours.model.hotels.Hotel
import ru.yandex.tours.model.search.SearchType
import ru.yandex.tours.model.search.SearchType.SearchType
import ru.yandex.tours.util.parsing
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 18.11.15
 */
object SearchTypeFilterHolder extends HotelFilterHolder with CommonDirectives {
  private def parse: PartialFunction[String, SearchType] =  {
    case parsing.IntValue(i) => SearchType(i)
    case x => SearchType.withName(x.toUpperCase)
  }

  private def valueOf: PartialFunction[FilterableValue, SearchType] = {
    case IntValue(i) => SearchType(i)
    case StringValue(s) => SearchType.withName(s.toUpperCase)
  }

  override def getValues(hotel: Hotel): Seq[FilterableValue] = SearchType.values
    .filter(hotel.searchAvailable)
    .map(st => StringValue(st.toString)).toSeq

  override def directive = array(name, isEmptyOk = true) hmap {
    case types :: HNil => new SearchTypeFilter(types.map(parse): _*)
  }

  override def name: String = SearchTypeFilter.name

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect { case x: StringValue => x.x })

  override def getValues: Seq[FilterableValue] = SearchType.values.map(st => StringValue(st.toString)).toSeq

  override def construct(values: Seq[FilterableValue]): HotelFilter =
    new SearchTypeFilter(values.collect(valueOf): _*)
}