package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.hotel.StarFilter
import ru.yandex.tours.model.filter.{HotelFilter, FilterableValue, StringValue}
import ru.yandex.tours.model.hotels.{Star, Hotel}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}

object StarFilterHolder extends HotelFilterHolder with CommonDirectives {
  override def getValues(hotel: Hotel): Seq[FilterableValue] = Seq(StringValue(hotel.star.id.toString))

  override def directive = intArray(name, isEmptyOk = true) hmap {
    case stars :: HNil => StarFilter(stars.map(_.toString).map(StringValue))
  }

  override def name: String = StarFilter.name

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })

  override def getValues: Seq[FilterableValue] = Star.stars.map(_.id).map(_.toString).map(StringValue)

  override def construct(values: Seq[FilterableValue]): HotelFilter = StarFilter(values.collect { case x: StringValue => x})
}
