package ru.yandex.tours.filter.holder.hotel

import ru.yandex.tours.filter.HotelFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.hotel.WifiFilter
import ru.yandex.tours.model.filter.{HotelFilter, FilterableValue, StringValue}
import ru.yandex.tours.model.hotels.Features.MultipleFeatureValue
import ru.yandex.tours.model.hotels.Hotel
import shapeless.{::, HNil}
import spray.routing.Directive1
import spray.routing.Directives._

object WifiFilterHolder extends HotelFilterHolder {
  override def getValues(hotel: Hotel): Seq[FilterableValue] = {
    val exists = hotel.features.exists(featureValue => featureValue.feature.name == "internet_in_hotel" && freeWifiValues(featureValue.asInstanceOf[MultipleFeatureValue].value))
    if (exists) {
      Seq(StringValue("free"))
    } else {
      Seq.empty
    }
  }

  override def directive: Directive1[WifiFilter] = parameter("wifi".?) map { optWifi =>
    WifiFilter(optWifi.map(StringValue).toSeq)
  }

  override def name: String = WifiFilter.name

  private def freeWifiValues(values: Set[String]) = values.exists(freeWifiValue)

  private def freeWifiValue(value: String) = value.startsWith("free_wi_fi")

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })

  override def getValues: Seq[FilterableValue] = Seq(StringValue("free"))

  override def construct(values: Seq[FilterableValue]): HotelFilter =
    WifiFilter(values.collect { case x: StringValue => x })
}