package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.filter.SnippetFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.snippet.ExcludeTourByIdFilter
import ru.yandex.tours.model.filter.{FilterableValue, StringValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}

object ExcludeTourByIdFilterHolder extends SnippetFilterHolder with CommonDirectives {
  override def name: String = ExcludeTourByIdFilter.name

  override def directive = array(name, isEmptyOk = true) hmap {
    case ids :: HNil => ExcludeTourByIdFilter(ids.toSet)
  }

  override def getValues(snippet: HotelSnippet) = Seq.empty

  override def getValues(offer: Offer) = Seq(StringValue(offer.getId))

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })
}
