package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.model.filter.snippet.ExcludePartnerFilter
import ru.yandex.tours.util.spray.Bindings
import shapeless.{::, HNil}
import spray.routing._

/**
  * Created by asoboll on 03.03.17.
  */
trait ExperimentalPartnerFilterHolder extends AlwaysHiddenFilterHolder with Bindings {
  val enabledflag: String
  val partners: Set[Int]

  val showPartner = ExcludePartnerFilter(name, Set.empty)
  val hidePartner = ExcludePartnerFilter(name, partners)

  override def directive: Directive1[ExcludePartnerFilter] = {
    experiments hmap {
      case flags :: HNil if flags.contains(enabledflag) => showPartner
      case _ => hidePartner
    }
  }
}
