package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.filter.SnippetFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, IntValues}
import ru.yandex.tours.model.filter.snippet.HotelIdFilter
import ru.yandex.tours.model.filter.{FilterableValue, IntValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import shapeless.{::, HNil}
import spray.routing.Directives._

object HotelIdFilterHolder extends SnippetFilterHolder {
  override def name: String = HotelIdFilter.name

  override def directive = parameter(name.as[Int].?) hmap {
    case hotelId :: HNil => HotelIdFilter(hotelId)
  }

  override def getValues(snippet: HotelSnippet): Seq[FilterableValue] = Seq(IntValue(snippet.getHotelId))

  override def getValues(offer: Offer): Seq[FilterableValue] = Seq(IntValue(offer.getHotelId))

  override def toState(values: Set[FilterableValue]): AllowedState = IntValues(name, values.collect {
    case IntValue(x) => x
  })
}
