package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.model.filter.snippet.{HotelProviderFilter, SearchSourceFilter}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}
import spray.routing.Directive1

object HotelProviderFilterHolder extends SearchSourceFilterHolder with CommonDirectives {
  override def name: String = HotelProviderFilter.name

  override def directive: Directive1[SearchSourceFilter] = {
    intArray(name, isEmptyOk = true) & intArray("hp", isEmptyOk = true) hmap {
      case operatorOld :: operatorNew :: HNil => SearchSourceFilter(name, (operatorOld ++ operatorNew).toSet)
    }
  }
}
