package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.filter.SnippetFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.BaseModel.Pansion
import ru.yandex.tours.model.filter.{FilterableValue, StringValue}
import ru.yandex.tours.model.filter.snippet.PansionFilter
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.util.spray.CommonDirectives
import spray.routing.Directive1

import scala.collection.JavaConverters._

object PansionFilterHolder extends SnippetFilterHolder with CommonDirectives {
  override def name: String = PansionFilter.name

  override def directive: Directive1[PansionFilter] = array(name, isEmptyOk = true) map { rawPansions =>
    val pansions = rawPansions.map(raw => Pansion.valueOf(raw.toUpperCase))
    PansionFilter(pansions.toSet)
  }

  override def getValues(snippet: HotelSnippet): Seq[FilterableValue] =
    snippet.getPansionsList.asScala.map(_.getPansion).map(pansionToString).map(StringValue)

  override def getValues(offer: Offer): Seq[FilterableValue] = Seq(StringValue(pansionToString(offer.getPansion)))

  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case StringValue(x) => x
  })

  private def pansionToString(x: Pansion): String = x.toString.toLowerCase
}
