package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.filter.SnippetFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, IntValues}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}
import ru.yandex.tours.model.filter.snippet.PriceFilter
import ru.yandex.tours.model.filter.{FilterableValue, IntValue}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}

object PriceFilterHolder extends SnippetFilterHolder with CommonDirectives {
  override def name: String = PriceFilter.name

  override def directive = range(name, _.toInt).hmap {
    case from :: to :: HNil => PriceFilter(from, to)
  }

  override def getValues(snippet: HotelSnippet): Seq[FilterableValue] = Seq(IntValue(snippet.getPriceMin))

  override def getValues(offer: Offer): Seq[FilterableValue] = Seq(IntValue(offer.getPrice))

  override def toState(values: Set[FilterableValue]): AllowedState = IntValues(name, {
    val prices = values.collect { case IntValue(x) => x }
    if (prices.isEmpty) {
      Iterable.empty
    } else {
      Iterable(prices.min, prices.max)
    }
  })
}
