package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.filter.SnippetFilterHolder
import ru.yandex.tours.filter.State.{AllowedState, StringValues}
import ru.yandex.tours.model.filter.{FilterableValue, IntValue}
import ru.yandex.tours.model.search.SearchProducts.{HotelSnippet, Offer}

import scala.collection.JavaConverters._

trait SearchSourceFilterHolder extends SnippetFilterHolder {
  override def getValues(snippet: HotelSnippet): Seq[FilterableValue] =
    snippet.getSourceList.asScala.map(_.getOperatorId).map(IntValue)

  override def getValues(offer: Offer): Seq[FilterableValue] = Seq(IntValue(offer.getSource.getOperatorId))

  // Guys from ui asked to make tour_operator as string
  override def toState(values: Set[FilterableValue]): AllowedState = StringValues(name, values.collect {
    case IntValue(x) => x.toString
  })
}
