package ru.yandex.tours.filter.holder.snippet

import ru.yandex.tours.model.filter.snippet.{SearchSourceFilter, TourOperatorFilter}
import ru.yandex.tours.util.spray.CommonDirectives
import shapeless.{::, HNil}
import spray.routing.Directive1

object TourOperatorFilterHolder extends SearchSourceFilterHolder with CommonDirectives {
  override def name: String = TourOperatorFilter.name

  override def directive: Directive1[SearchSourceFilter] = {
    intArray(name, isEmptyOk = true) & intArray("top", isEmptyOk = true) hmap {
      case operatorOld :: operatorNew :: HNil => SearchSourceFilter(name, (operatorOld ++ operatorNew).toSet)
    }
  }
}
