package ru.yandex.tours.geo

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDefWithDependencies, DataTypes}
import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.geo.base.region.Tree
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}
import shapeless._

import scala.collection.mutable

class Iso2Country(iso2Country: Map[String, Region]) {
  def get(iso: String): Option[Region] = iso2Country.get(iso)
}

object Iso2Country extends DataDefWithDependencies[Iso2Country, Tree :: HNil] {
  override def dataType: DataType = DataTypes.iso2country

  override def dependsOn: Set[DataType] = Set(DataTypes.regions)

  override def parse(is: InputStream, dependencies: Tree :: HNil): Iso2Country = {
    val map = mutable.HashMap.empty[String, Region]
    val tree = dependencies.head
    scala.io.Source.fromInputStream(is).getLines().foreach {
      case Tabbed(iso, IntValue(geoId)) => tree.region(geoId).foreach(map.put(iso, _))
    }
    new Iso2Country(map.toMap)
  }

  def empty: Iso2Country = new Iso2Country(Map.empty[String, Region])
}