package ru.yandex.tours.geo

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDefWithDependencies, DataTypes}
import ru.yandex.tours.geo.mapping.GeoMappingHolder
import ru.yandex.tours.model.hotels.Partners
import ru.yandex.tours.util.IO
import shapeless._

/**
  * Created by asoboll on 29.04.16.
  */
case class LtActiveCountries(set: Set[Int])

object LtActiveCountries extends DataDefWithDependencies[LtActiveCountries, GeoMappingHolder :: HNil]{
  override def dataType: DataType = DataTypes.ltActiveCountries
  override def dependsOn: Set[DataType] = Set(DataTypes.countries)

  def empty: LtActiveCountries = LtActiveCountries(Set.empty)

  override def parse(is: InputStream, dependencies: GeoMappingHolder :: HNil): LtActiveCountries = {
    val geoMappingHolder = dependencies.head

    val ids = for {
      ltId <- IO.readLines(is)
      id <- geoMappingHolder.getGeoIdByCountry(Partners.lt, ltId)
    } yield id

    LtActiveCountries(ids.toSet)
  }
}
