package ru.yandex.tours.geo.base

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataDef, DataTypes}
import ru.yandex.tours.util.Collections._
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{IntValue, Tabbed}

/**
  * Created by asoboll on 08.02.16.
  */
object GeoSynonyms extends DataDef[Map[region.Id, List[String]]] {
  override def dataType: DataType = DataTypes.geoSynonyms

  def parse(is: InputStream): Map[region.Id, List[String]] =
    IO.readLines(is).flatMap {
      case Tabbed(IntValue(geoId), ruName, synonym, isManual) =>
        Some((geoId, synonym))
      case Tabbed(IntValue(geoId), ruName, synonym) =>
        Some((geoId, synonym))
      case "geoId\tname\tsynonym\tmanual" => None
    }.toIterable.toMultiMap
}