package ru.yandex.tours.geo.base

import ru.yandex.tours.model.LocalizedString
import ru.yandex.tours.model.geo.MapObject

/**
  * Created by asoboll on 19.02.16.
  */
trait RegionBase[U] extends MapObject {
  def id: U

  def name: LocalizedString

  def longitude: Double
  def latitude: Double

  def synonyms: Set[String]

  def getName: String = name.ruName

  def allNames: Set[String] = (name.allValues ++ synonyms).toSet
}