package ru.yandex.tours.geo.base.custom

import ru.yandex.tours.geo.base.region.{Types, Tree}
import ru.yandex.tours.geo.base.{Region, region}

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 20.11.15
 */
case class CustomRegion(id: Int,
                        isNew: Boolean,
                        partialRegion: PartialRegion,
                        children: Seq[Int]) {

  def isMeta = partialRegion.`type`.contains(Types.MetaRegion)

  def modify: Tree => Option[Region] = { tree: Tree =>
    if (isNew) {
      if (partialRegion.isComplete) {
        Some(partialRegion.toRegion(id, children))
      } else Option.empty
    } else {
      for {
        old <- tree.region(id)
      } yield {
        partialRegion.patch(old)
      }
    }
  }
}

object CustomRegion {
  def apply(tree: region.Tree, customs: Seq[CustomRegion]): region.Tree = {
    val newMap = customs.foldLeft(tree.regions.map(r => r.id -> r).toMap) {
      case (map, cr) =>
        val newRegions = cr.modify(tree)
        map ++ newRegions.map(r => r.id -> r)
    }

    new region.Tree(newMap.values)
  }
}