package ru.yandex.tours.geo.base.export

import java.io.Writer

import ru.yandex.common.util.xml.XmlWriter
import ru.yandex.tours.geo.base.Region
import ru.yandex.tours.model.Languages

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 26.11.15
 */
class RegionsXmlWriter(writer: Writer) {

  private val xml = new XmlWriter(writer)

  xml.startDocument()
  xml.startTag("geobase")
  
  def write(region: Region): Unit = {
    xml.startTag("region")

    xml.addAttributes(
      "id", region.id.toString,
      "name", region.name.values.getOrElse(Languages.ru, ""),
      "type", region.`type`.id.toString,
      "parent", region.parentId.toString,
      "position", region.position.toString,
      "syn", region.synonyms.mkString(","),
      "ua_name", region.name.values.getOrElse(Languages.ua, ""),
      "by_name", region.name.values.getOrElse(Languages.by, ""),
      "kz_name", region.name.values.getOrElse(Languages.kz, ""),
      "en_name", region.name.values.getOrElse(Languages.en, ""),
      "tr_name", region.name.values.getOrElse(Languages.tr, ""),
      "lat", region.latitude.toString,
      "lon", region.longitude.toString,
      "min_lat", region.boundingBox.minLat.toString,
      "min_lon", region.boundingBox.minLon.toString,
      "max_lat", region.boundingBox.maxLat.toString,
      "max_lon", region.boundingBox.maxLon.toString,
      "genitive", region.genitive,
      "dative", region.dative,
      "accusative", region.accusative,
      "locative", region.locative,
      "preposition", region.preposition,
      "children", region.childrenIds.mkString(","),
      "short_ename", region.isoCode.getOrElse("")
    )

    region.timeZone.foreach { tz =>
      xml.addAttributes("tzname", tz.getID)
    }

    xml.endTag()
  }

  def close(): Unit = {
    xml.endTag()
    writer.close()
  }
}
