package ru.yandex.tours.geo.base.region

import java.io.InputStream

import ru.yandex.extdata.common.meta.DataType
import ru.yandex.tours.extdata.{DataTypes, DataDef}
import ru.yandex.tours.model.MapRectangle
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.{DoubleValue, IntValue, Tabbed}

class RegionBoundaries(map: Map[Int, MapRectangle]) {
  def getBoundaries(geoId: Int): Option[MapRectangle] = map.get(geoId)
}

object RegionBoundaries extends DataDef[RegionBoundaries] {
  override def dataType: DataType = DataTypes.regionBoundaries

  override def parse(is: InputStream): RegionBoundaries = {
    val boundaries = IO.readLines(is).map {
      case Tabbed(IntValue(geoId), DoubleValue(minLon), DoubleValue(minLat), DoubleValue(maxLon), DoubleValue(maxLat)) =>
        geoId -> MapRectangle.byBoundaries(minLon, minLat, maxLon, maxLat)
    }
    new RegionBoundaries(boundaries.toMap)
  }

  val empty = new RegionBoundaries(Map.empty)
}
