package ru.yandex.tours.geo.base.region

/** Available region types according to
  * http://wiki.yandex-team.ru/LeonidMovsesjan/Geobase/ServantMethodsDocumentation#tipyregionov
  */
object Types extends Enumeration {
  val Hidden = Value(-1)
  val Other = Value(0)
  val Continent = Value(1)
  val Region = Value(2)
  val Country = Value(3)
  val FederalDistrict = Value(4)
  val FederalSubject = Value(5)
  val City = Value(6)
  val Village = Value(7)
  val CityDistrict = Value(8)
  val MetroStation = Value(9)
  val FederalSubjectRegion = Value(10)
  val Airport = Value(11)
  val OverseasLand = Value(12)
  val SecondLevelCityDistrict = Value(13)
  val MonorailStation = Value(14)
  val RuralSettlement = Value(15)
  val Beach = Value(96)
  val SkiResort = Value(97)
  val MetaRegion = Value(98)
  val MultiPurpose = Value(99)
}
