package ru.yandex.tours.geo.mapping

import ru.yandex.tours.model.search.SearchType._

/**
 * Author: Vladislav Dolbilov (darl@yandex-team.ru)
 * Created: 15.04.16
 */
trait PartnerGeoMapping {

  def countryGeoIds: Set[Int]
  def cityGeoIds: Set[Int]
  def departuresGeoIds: Set[Int]

  def getPartnerCountry(geoId: Int): Option[String]
  def getPartnerCity(geoId: Int): Option[String]
  def getPartnerDestination(geoId: Int): Option[String]
  def getPartnerDeparture(geoId: Int): Option[String]
  def getPartnerAirport(geoId: Int): Option[String]

  def getGeoIdByCity(id: String): Option[Int]
  def getGeoIdByCountry(id: String): Option[Int]
  def getGeoIdByAirport(id: String): Option[Int]

  def getGeoId(id: String): Option[Int]

  def isKnownDestCountry(id: Int): Boolean
  def isKnownDestCountry(id: Int, searchType: SearchType): Boolean

  def isKnownDestCity(id: Int): Boolean
  def isKnownDestCity(id: Int, searchType: SearchType): Boolean

  def isKnownDestination(id: Int): Boolean
  def isKnownDestination(id: Int, searchType: SearchType): Boolean

  def isDepartureCity(id: Int): Boolean
}
