package ru.yandex.tours.geo.matching

import ru.yandex.tours.geo.base.{Region, region}
import ru.yandex.tours.geo.mapping.GeoMappingShort
import ru.yandex.tours.geo.partners.{PartnerRegion, PartnerTree}
import ru.yandex.tours.model.hotels.Partners.Partner

import scala.util.Try

/**
  * Created by asoboll on 04.04.17.
  */
class PartnerHypotheses(tree: region.Tree,
                        partnerTree: PartnerTree,
                        geoIds: Array[region.Id],
                        partnerIds: Array[String],
                        confidences: Array[Double]) {
  require(geoIds.length == partnerIds.length)
  require(geoIds.length == confidences.length)

  def this(partner: Partner) = this(region.Tree.empty,
    new PartnerTree(partner, Map.empty), Array.empty, Array.empty, Array.empty)

  def partner: Partner = partnerTree.partner

  private def getHypothesis(i: Int): Option[Hypothesis] = {
    Try(Hypothesis(
      tree.region(geoIds(i)).get,
      partnerTree.header(partnerIds(i)).get,
      confidences(i)
    )).toOption
  }

  def filter(p: Partner, q: ((region.Id, String) => Boolean)): Iterator[Hypothesis] = {
    if (p != partner) return Iterator.empty
    for {
      i <- geoIds.indices.iterator
      if q(geoIds(i), partnerIds(i))
      hypothesis <- getHypothesis(i)
    } yield hypothesis
  }

  def findRelated(hyp: Hypothesis): Iterator[Hypothesis] =
    filter(hyp.partner, _ == hyp.yandexRegion.id || _ == hyp.partnerId)

  def findHypothesis(geoMappingShort: GeoMappingShort): Option[Hypothesis] =
    filter(geoMappingShort.partner, _ == geoMappingShort.geoId && _ == geoMappingShort.partnerId).toStream.headOption

  def byPartnerRegion(region: PartnerRegion): Iterator[Hypothesis] =
    filter(region.partner, (_, prid) => prid == region.id)

  def byYandexRegion(region: Region, p: Partner): Iterator[Hypothesis] =
    filter(p, (yaid, _) => yaid == region.id)
}
