package ru.yandex.tours.geo.partners

import java.io._

import ru.yandex.tours.model.geo.PartnerObject
import ru.yandex.tours.model.hotels.Partners.Partner
import ru.yandex.tours.util.IO
import ru.yandex.tours.util.parsing.Tabbed
import ru.yandex.vertis.curator.recipes.map.ValueSerializer

import scala.util.Try

/**
  * Created by asoboll on 24.03.16.
  */
case class ExtendedPartnerRegion(region: PartnerRegion,
                                 parentId: Option[String],
                                 childrenIds: Seq[String]) extends PartnerObject {
  def partner: Partner = region.partner
  def id: String = region.id
}

object ExtendedPartnerRegion extends ValueSerializer[ExtendedPartnerRegion] {
  def serialize(r: ExtendedPartnerRegion): Array[Byte] = {
    IO.printBytes { pw =>
      pw.println(Tabbed(r.parentId.getOrElse(""), r.childrenIds.mkString("#")))
      pw.println(PartnerRegionParser.writeString(r.region))
    }
  }

  def deserialize(bytes: Array[Byte]): Try[ExtendedPartnerRegion] = {
    val is = new ByteArrayInputStream(bytes)
    val lines = IO.readLines(is)
    val Seq(ids, regionBytes) = lines.take(2).toSeq
    for {
      region <- PartnerRegionParser.deserialize(regionBytes)
    } yield ids match {
      case Tabbed("", children) =>
        ExtendedPartnerRegion(region, None, children.split("#"))
      case Tabbed(parent, children) =>
        ExtendedPartnerRegion(region, Some(parent), children.split("#"))
    }
  }
}