package ru.yandex.tours.geo.partners

import java.io.InputStream

import org.apache.commons.io.IOUtils
import ru.yandex.extdata.common.exception.{DataIsNotLoadedException, UnableToLoadDataException}
import ru.yandex.extdata.common.meta.DataType
import ru.yandex.extdata.common.service.ExtDataService
import ru.yandex.tours.extdata.DataDef
import ru.yandex.tours.util.{IO, Logging}

import scala.concurrent.duration._

/**
  * Created by asoboll on 10.03.17.
  */
class MappedPartnerTreeHolder(val dataType: DataType)
  extends DataDef[MappedPartnerTree] with Logging {

  override def from(extDataService: ExtDataService): MappedPartnerTree = {
    try {
      super.from(extDataService)
    } catch {
      case _: DataIsNotLoadedException | _: UnableToLoadDataException =>
        log.warn(s"No previous ${dataType.getName}. Using empty one.")
        MappedPartnerTree.empty
    }
  }

  override def parse(is: InputStream): MappedPartnerTree = {
    val file = IO.usingTmp(dataType.getName) { os => IOUtils.copy(is, os) }
    val tree = MappedPartnerTree.fromFile(file)
    tree.load()
    tree
  }

  override protected def onChange(oldValue: Option[MappedPartnerTree], newValue: MappedPartnerTree): Unit = {
    oldValue.foreach(_.closeAfter(1.minute))
    oldValue.foreach(_.delete())
  }
}
